// Scmp.h: interface for the CScmp class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCMP_H__CEF7C975_4A2B_4727_A8F4_DC6BBF334A65__INCLUDED_)
#define AFX_SCMP_H__CEF7C975_4A2B_4727_A8F4_DC6BBF334A65__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define HALT 0x00
#define XAE  0x01
#define CCL  0x02
#define SCL  0x03
#define DINT 0x04
#define IEN  0x05
#define CSA  0x06
#define CAS  0x07
#define NOP  0x08

#define SIO  0x19
#define SR   0x1c
#define SRL  0x1d
#define RR   0x1e
#define RRL  0x1f

#define XPAL 0x30
#define XPAH 0x34
#define XPPC 0x3c

#define LDE  0x40
#define	ANE  0x50
#define	ORE  0x58
#define	XRE  0x60
#define DAE  0x68
#define ADE  0x70
#define CAE  0x78

#define DLY  0x8f

#define JMP  0x90
#define JP   0x94
#define JZ   0x98
#define JNZ  0x9c

#define ILD  0xa8
#define DLD  0xb8

#define LD   0xc0
#define ST   0xc8
#define AND  0xd0
#define OR   0xd8
#define XOR  0xe0
#define DAD  0xe8
#define ADD  0xf0
#define CAD  0xf8

#define WRITECHAR 0x20
#define READCHAR  0x21

class CScmp  
{
public:
	void Run();
	void Reset();
	BYTE m_mem[0x10000];
	CScmp();
	virtual ~CScmp();

protected:
	BOOL m_stop;
	WORD CalcEA(WORD& p);
	void CalcPC(WORD p);
	void Execute();
	void Fetch();
	BYTE Add(BYTE x, BYTE y);
	BYTE DecAdd(BYTE x, BYTE y);
	char m_op;
	BYTE m_instr;
	BYTE m_acc;
	BYTE m_ext;
	BYTE m_stat;
	WORD m_p[4];
};

#endif // !defined(AFX_SCMP_H__CEF7C975_4A2B_4727_A8F4_DC6BBF334A65__INCLUDED_)
