// Scmp.cpp: implementation of the CScmp class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Scmp.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CScmp::CScmp()
{
	Reset();
}

CScmp::~CScmp()
{

}

void CScmp::Reset()
{
	m_stop = FALSE;
	m_acc = m_ext = 0;
	m_p[0] = m_p[1] = m_p[2] = m_p[3] = 0;
	m_stat = 0;
}

void CScmp::Fetch()
{
	m_p[0] = (m_p[0] + 1) & 0xFFF;
	m_instr = m_mem[m_p[0]];
	if (m_instr & 0x80)
	{
		m_p[0] = (m_p[0] + 1) & 0xFFF;
		m_op = m_mem[m_p[0]];
	}
}

void CScmp::Execute()
{

	if (m_instr < 0x30)
	{
		BYTE tmp, tmp1;
		switch (m_instr)
		{
		case HALT:
			m_stop = TRUE;
			break;
		case XAE:
			tmp = m_acc;
			m_acc = m_ext;
			m_ext = tmp;
			break;
		case CCL:
			m_stat &= 0x7f;
			break;
		case SCL:
			m_stat |= 0x80;
			break;
		case DINT:
			m_stat &= 0xf7;
			break;
		case IEN:
			m_stat |= 0x08;
			break;
		case CSA:
			if (kbhit())
				m_stat &= 0xDF;
			else
				m_stat |= 0x20;
			m_acc = m_stat;
			break;
		case CAS:
			m_stat = m_acc;
			break;
		case NOP:
			break;

		case SIO:
			// no hardware
			m_ext >>= 1;
			break;
		case SR:
			m_acc >>= 1;
			break;
		case SRL:
			m_acc >>= 1;
			m_acc |= (m_stat & 0x80);
		case RR:
			tmp = m_acc;
			m_acc >>= 1;
			if (tmp & 1)
				m_acc |= 0x80;
			break;
		case RRL:
			tmp = m_acc;
			tmp1 = m_stat;
			m_acc >>= 1;
			if (tmp & 1)
				m_stat |= 0x80;
			else
				m_stat &= 0x7f;
			if (tmp1 & 0x80)
				m_acc |= 0x80;
			else
				m_acc &= 0x7f;
			break;
		case WRITECHAR:
			_putch(m_acc & 0x7f);
			break;
		case READCHAR:
			m_acc = m_ext = toupper(_getch());
			if (m_acc == 0x1a)
				m_stop = TRUE;
			if (m_acc == 0x08)
				putchar('\b');
			if (m_acc >= 0x20)
				_putch(m_acc & 0x7f);
			break;
		default:
			break;
		}
	}
	else if (m_instr < 0x40)
	{
		int idx = m_instr & 0x03;
		PBYTE ptrbyte;
		BYTE tmp;
		WORD tmp1;

		switch (m_instr & 0xFC)
		{
		case XPAL:
			ptrbyte = (PBYTE) (m_p + idx);
			tmp = *ptrbyte;
			*ptrbyte = m_acc;
			m_acc = tmp;
			break;
		case XPAH:
			ptrbyte = (PBYTE) (m_p + idx) + 1;
			tmp = *ptrbyte;
			*ptrbyte = m_acc;
			m_acc = tmp;
			break;
		case XPPC:
			tmp1 = m_p[idx];
			m_p[idx] = m_p[0];
			m_p[0] = tmp1;
			break;
		}
	}
	else if (m_instr < 0x80)
	{
		switch (m_instr)
		{
		case LDE:
			m_acc = m_ext;
			break;
		case ANE:
			m_acc &= m_ext;
			break;
		case ORE:
			m_acc |= m_ext;
			break;
		case XRE:
			m_acc ^= m_ext;
			break;
		case DAE:
			m_acc = DecAdd(m_acc, m_ext);
			break;
		case ADE:
			m_acc = Add(m_acc, m_ext);
			break;
		case CAE:
			m_acc = Add(m_acc, m_ext ^ 0xFF);
			break;
		}
	}
	else if (m_instr < 0x90)
	{
		// DLY
	}
	else if (m_instr < 0xA0)
	{
		int idx = m_instr & 0x03;

		switch (m_instr & 0xFC)
		{
		case JMP:
			CalcPC(m_p[idx]);
			break;
		case JP:
			if (!(m_acc & 0x80))
				CalcPC(m_p[idx]);
			break;
		case JZ:
			if (m_acc == 0)
				CalcPC(m_p[idx]);
			break;
		case JNZ:
			if (m_acc != 0)
				CalcPC(m_p[idx]);
			break;
		}
	}
	else if (m_instr < 0xC0)
	{
		int idx = m_instr & 0x03;
		WORD ea = CalcEA(m_p[idx]);

		switch (m_instr & 0xFC)
		{
		case ILD:
			m_acc = ++m_mem[ea];
			break;
		case DLD:
			m_acc = --m_mem[ea];
			break;
		}
	}
	else
	{
		int idx = m_instr & 0x03;
		WORD ea = CalcEA(m_p[idx]);

		switch (m_instr & 0xF8)
		{
		case LD:
			m_acc = m_mem[ea];
			break;
		case ST:
			m_mem[ea] = m_acc;
			break;
		case AND:
			m_acc &= m_mem[ea];
			break;
		case OR:
			m_acc |= m_mem[ea];
			break;
		case XOR:
			m_acc ^= m_mem[ea];
			break;
		case DAD:	
			m_acc = DecAdd(m_acc, m_mem[ea]);
			break;
		case ADD:	
			m_acc = Add(m_acc, m_mem[ea]);
			break;
		case CAD:	
			m_acc = Add(m_acc, m_mem[ea] ^ 0xFF);
			break;
		}
	}
}
	
void CScmp::Run()
{
	while (!m_stop)
	{
		Fetch();
		Execute();
	}
}

BYTE CScmp::Add(BYTE x, BYTE y)
{
	int sum;
	int ov;

	sum = x + y;
	if (m_stat & 0x80)
		sum++;
	if (sum & 0x100)
		m_stat |= 0x80;
	else
		m_stat &= 0x7F;
	ov = sum >> 7;
	if (ov == 0x00 || ov == 0x03)
		m_stat &= 0xBF;
	else
		m_stat |= 0x40;
	return sum;
}

BYTE CScmp::DecAdd(BYTE x, BYTE y)
{
	// This Function Performes a Decimal (BCD)
	// Add on two BCD-coded bytes. The
	// Carry is included in the operation and the
	// resulting carry is updated in the status-reg.
	BYTE xh, xl, yh, yl, zh, zl;
	int dcy = 0;

	xh = (x & 0xF0) >> 4;
	xl = x & 0x0F;
	yh = (y & 0xF0) >> 4;
	yl = y & 0x0F;
	zl = xl + yl;
	if (m_stat & 0x80)
		zl++;
	if (zl > 9)
	{
		dcy = 1;
		zl -= 10;
	}
	zh = yh + xh + dcy;
	if (zh > 9)
	{
		m_stat |= 0x80;
		zh -= 10;
	}
	else
		m_stat &= 0x7f;
	return zh << 4 | zl;
}

void CScmp::CalcPC(WORD p)
{
	char disp;

	if (m_op == -128)
		disp = (char) m_ext;
	else
		disp = m_op;
	m_p[0] = p + disp;
}

WORD CScmp::CalcEA(WORD& p)
{
	WORD ea;

	if ((m_instr & 0x07) == 0x04)
	{
		ea = m_p[0];
	}
	else
	{
		char disp;

		if (m_op == -128)
			disp = (char) m_ext;
		else
			disp = m_op;
		if (m_instr & 0x04)
		{
			if (disp < 0)
			{
				p += disp;
				ea = p;
			}
			else
			{
				ea = p;
				p += disp;
			}
		}
		else
		{
			ea = p + disp;
		}
	}
	return ea;
}
